class RPGMutator extends Mutator config(MSRPG);

var string SummonClass;
var Config class<actor> ApprovedClasses[100];
var PlayerPawn Suspended[20];
var Config bool bAllowSummoning;

function PostBeginPlay()
{   
	Level.Game.BaseMutator.AddMutator(Self);
	Level.Game.RegisterDamageMutator(Self);
}

function SummonShit(PlayerPawn Player, String SummonClass)
{
       local class<actor> ShitToSummon;
       local int j;

       log( "Fabricate " $ SummonClass );
       ShitToSummon = class<actor>( DynamicLoadObject( SummonClass, class'Class' ) );
       j = InStr(SummonClass, ".");
       if (j > -1)
       {
	if (ShitToSummon != None)
        {
         if (bShouldSpawn(ShitToSummon))
         {
		// DEUS_EX STM
		//Spawn( NewClass,,,Location + 72 * Vector(Rotation) + vect(0,0,1) * 15 );
		Spawn( ShitToSummon,Player,,Player.Location + (Player.CollisionRadius+ShitToSummon.Default.CollisionRadius+30) * Vector(Player.Rotation) + vect(0,0,1) * 15 );
                BroadcastMessage("|p7"$Player.PlayerReplicationInfo.PlayerName$"|p3 summoned a "$ShitToSummon$".");
         }
         else
          Player.ClientMessage("|p2ERROR: Class |p4"$SummonClass$"|p2 is not allowed!");

        }
        else
         Player.ClientMessage("|p2ERROR: Cannot Find Actor |p4"$SummonClass$"!");
       }
       if (j == -1)
         Player.ClientMessage("|p2ERROR: You must specify the package name!");
}

simulated function bool bInList(PlayerPawn P)
{
	local int i;

		for (i=0;i<ArrayCount(Suspended);i++)
			if (Suspended[i] == P)
				return True;
	return False;
}

simulated function bool bShouldSpawn(class<actor> ActorName)
{
	local int i;
	
	for (i=0;i<ArrayCount(ApprovedClasses);i++)
			if (ApprovedClasses[i] == ActorName)
				return True;

	return False;
}

function SummonBan(PlayerPawn Player)
{
	local Actor           hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
        local int i;

	position    = Player.Location;
	position.Z += Player.BaseEyeHeight;
	line        = Vector(Player.ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);
	if (hitActor != None)
	{
          if ((hitActor.IsA('PlayerPawn')))
          {
		for (i=0;i<ArrayCount(Suspended);i++) // not sure which of these is their definition of blank so ill just accept any...
			if ((Suspended[i] == None) && (!bInList(PlayerPawn(hitActor))))
                        {
				Suspended[i] = PlayerPawn(hitActor);
                                PlayerPawn(HitActor).ClientMessage("|p2You have just been banned from summoning.");
                                break;                  
                        }
                        else
                        {
                         Player.ClientMessage("|p2ERROR: Either Player is Already Banned or Ban List Is Full.");
                         return;
                        }
          }
        }
}

function DeleteShit(PlayerPawn Player)
{
	local Actor           hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;

	position    = Player.Location;
	position.Z += Player.BaseEyeHeight;
	line        = Vector(Player.ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);
	if (hitActor != None)
	{
          if ((!hitActor.IsA('PlayerPawn')))
          {
           if (!Player.bAdmin)
           {
            if (hitActor.Owner == Player)
            {
             Player.ClientMessage("|p3"$hitActor.Class$" has been deleted, thank you for cleaning up :D");
             hitActor.Destroy();
             return;
            }
            else
             Player.ClientMessage("|p2ERROR: Actor does not belong to you.");
           }
           if (Player.bAdmin)
           {
             Player.ClientMessage("|p2"$hitActor.Class$" has been deleted, thank you for cleaning up :D");
             hitActor.Destroy();
             return;
           }
          }
        }
}

function Mutate(string S, PlayerPawn Player)
{
	local Pawn P;
	local String str, cmd;
	local int j, i;
        local DeusExPlayer DXP;

	j = InStr(S, " ");

        cmd = Left(S, j);
          if (cmd ~= "Summon")
          {
           if (bAllowSummoning)
           {
            if (!bInList(Player))
            {
//	     i = InStr(S, " ");
//           if (i > -1)
//           {
//            i = i - j;
              SummonClass = Mid(S, j + 1);
              SummonShit(Player, SummonClass);
//           }
/*           if (i == -1)
             {
              Player.ClientMessage("|p2ERROR: Proper format is mutate summon,(class) and then a space(no space after comma).");
              return;
             }*/
            }
            else
            {
             Player.ClientMessage("|p2ERROR: You are currently banned from RPG summoning.");
             return;
            }
           } 
           else
           {
            Player.ClientMessage("|p2ERROR: This command is currently disabled.");
            return;
           }
          }
          if (S ~= "SummonBan")
          {
           if (Player.bAdmin)
           {
            SummonBan(Player);
           } 
           else
           {
            Player.ClientMessage("|p2This command is for admins only.");
            return;
           }
          }
          if (S ~= "SummonBan")
          {
           DeleteShit(Player);
          }
Super.Mutate(S, Player);
}

function MutatorTakeDamage(out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
		if ((Victim.Region.Zone.IsA('ZoneInfo')) && (Victim.Region.Zone.bNeutralZone) || (InstigatedBy.Region.Zone.bNeutralZone))
		{
			ActualDamage = 0;
                        InstigatedBy.ClientMessage("|p2THIS IS A NO KILLING ZONE!");
		}
	Super.MutatorTakeDamage(ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
}

defaultproperties
{
}